# Szyfr kolumnowy:
# https://www.nostarch.com/crackingcodes (na licencji BSD).

import pyperclip

def main():
    myMessage = '''Augusta Ada King, hrabina Lovelace (ur. 10 grudnia 1815, zm. 27 listopada 1852) – brytyjska matematyczka i poetka, znana przede wszystkim z publikacji na temat mechanicznego komputera Charlesa Babbage’a, zwanego maszyną analityczną. Praca zawiera notatki, wśród nich pierwszy opublikowany algorytm napisany z zamiarem wykonania na maszynie. Z tego powodu uważana bywa za pierwszą programistkę.'''
    myKey = 13

    ciphertext = encryptMessage(myKey, myMessage)

    # Wyświetlenie szyfrogramu na ekranie, ze
    # znakiem potoku (|) na końcu, na wypadek
    # gdyby szyfrowana wiadomość kończyła się spacją.
    print(ciphertext + '|')

    # Skopiowanie szyfrogramu do schowka.
    pyperclip.copy(ciphertext)


def encryptMessage(key, message):
    # Każdy ciąg tekstowy w szyfrogramie przedstawia kolumnę siatki.
    ciphertext = [''] * key

    # Iteracja przez poszczególne kolumny szyfrogramu.
    for column in range(key):
        currentIndex = column

        # Pętla będzie wykonywana, dopóki wartość currentIndex nie będzie większa niż liczba określająca długość wiadomości.
        while currentIndex < len(message):
            # Znak znajdujący się w położeniu currentIndex w zmiennej message
            # zostaje umieszczony na końcu bieżącej kolumny listy szyfrogramu.
            ciphertext[column] += message[currentIndex]

            # Zwiększenie wartości zmiennej currentIndex o wartość klucza.
            currentIndex += key

    # Konwersja listy szyfrogramu na wartość w postaci pojedynczego ciągu tekstowego i jej zwrot.
    return ''.join(ciphertext)


# Jeżeli program transpositionEncrypt.py został uruchomiony (a nie
# zaimportowany jako moduł), wówczas należy wywołać funkcję main().
if __name__ == '__main__':
    main()